/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.adaptator.impl.XMLParser;
import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecHelper {
    private String specFilename;
    private IXMLElement spec;
    private boolean _haveSpec;
    public static final String YES = "yes";
    public static final String NO = "no";
    private static final String PACK_KEY = "pack";
    private static final String PACK_NAME = "name";

    public void readSpec(String string) throws Exception {
        this.readSpec(string, null);
    }

    public void readSpec(String string, VariableSubstitutor variableSubstitutor) throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = this.getResource(string);
        }
        catch (Exception exception) {
            this._haveSpec = false;
            return;
        }
        if (inputStream == null) {
            this._haveSpec = false;
            return;
        }
        this.readSpec(inputStream, variableSubstitutor);
        inputStream.close();
        this.specFilename = string;
    }

    public void readSpec(InputStream inputStream) throws Exception {
        this.readSpec(inputStream, null);
    }

    public void readSpec(InputStream inputStream, VariableSubstitutor variableSubstitutor) throws Exception {
        if (variableSubstitutor != null) {
            inputStream = this.substituteVariables(inputStream, variableSubstitutor);
        }
        XMLParser xMLParser = new XMLParser();
        this.spec = xMLParser.parse(inputStream);
        this._haveSpec = true;
    }

    public InputStream getResource(String string) {
        try {
            return ResourceManager.getInstance().getInputStream(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IXMLElement getPackForName(String string) {
        Vector<IXMLElement> vector = this.getSpec().getChildrenNamed(PACK_KEY);
        Iterator<IXMLElement> iterator = null;
        if (vector == null) {
            return null;
        }
        for (IXMLElement iXMLElement : vector) {
            String string2 = iXMLElement.getAttribute(PACK_NAME);
            if (!string2.equals(string)) continue;
            return iXMLElement;
        }
        return null;
    }

    public void parseError(IXMLElement iXMLElement, String string) throws InstallerException {
        throw new InstallerException(this.specFilename + ":" + iXMLElement.getLineNr() + ": " + string);
    }

    public boolean haveSpec() {
        return this._haveSpec;
    }

    public IXMLElement getSpec() {
        return this.spec;
    }

    public void setSpec(IXMLElement iXMLElement) {
        this.spec = iXMLElement;
    }

    public Vector<IXMLElement> getAllSubChildren(IXMLElement iXMLElement, String[] stringArray) {
        return this.getSubChildren(iXMLElement, stringArray, 0);
    }

    private Vector<IXMLElement> getSubChildren(IXMLElement iXMLElement, String[] stringArray, int n) {
        Vector<IXMLElement> vector;
        Vector<IXMLElement> vector2 = null;
        Vector<IXMLElement> vector3 = null;
        Vector<IXMLElement> vector4 = vector = iXMLElement != null ? iXMLElement.getChildrenNamed(stringArray[n]) : null;
        if (vector == null) {
            return null;
        }
        if (n < stringArray.length - 1) {
            Iterator<IXMLElement> iterator = vector.iterator();
            while (iterator.hasNext()) {
                vector3 = this.getSubChildren(iterator.next(), stringArray, n + 1);
                if (vector3 == null) continue;
                if (vector2 == null) {
                    vector2 = new Vector<IXMLElement>();
                }
                vector2.addAll(vector3);
            }
        } else {
            return vector;
        }
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream substituteVariables(InputStream inputStream, VariableSubstitutor variableSubstitutor) throws Exception {
        File file = File.createTempFile("izpacksubs", "");
        FileOutputStream fileOutputStream = null;
        file.deleteOnExit();
        try {
            fileOutputStream = new FileOutputStream(file);
            variableSubstitutor.substitute(inputStream, fileOutputStream, null, "UTF-8");
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return new FileInputStream(file);
    }

    public boolean isAttributeYes(IXMLElement iXMLElement, String string, boolean bl) {
        String string2 = iXMLElement.getAttribute(string, bl ? YES : NO);
        if (string2.equalsIgnoreCase(YES)) {
            return true;
        }
        if (string2.equalsIgnoreCase(NO)) {
            return false;
        }
        return bl;
    }

    public String getRequiredAttribute(IXMLElement iXMLElement, String string) throws InstallerException {
        String string2 = iXMLElement.getAttribute(string);
        if (string2 == null) {
            this.parseError(iXMLElement, "<" + iXMLElement.getName() + "> requires attribute '" + string + "'.");
        }
        return string2;
    }
}

